///////////////////////////////////////////////////////////////////////////////
//WRITTEN BY- ABHINAV KUMAR RASTOGI ROLL NO.-100070024 BATCH-16              //
//FOR THE CS101 PROJECT OF GRAPH PLOTTER                                     // 
//SUBMITTED ON 24 OCT 2010                                                   //
//INCLUDES FUNCTIONS FOR FINDING LOCAL MAXIMA, MINIMA AND DOUBLE DERIVATIVE  //
//THE PROGRAM HAS BEEN CHECKED FOR VARIOUS FUNCTIONAL INPUTS                 //
///////////////////////////////////////////////////////////////////////////////

//these header files are to be included in the main program
#include<iostream>
#include<cmath>
#define resolution 0.0001//accuracy in result is one decimal point less than resolution
#define size 10//defines the size of arrays in which local max and min are stored
using namespace std;


//the function wriiten below is just for checking
float function(float x){
      float a;
      a=sin(x);
      return a;
}


//this function rounds the x coordinates of the critical points to two decimal places
float round(float x){
      float a;
      int rem;
      x=(int)(x/resolution);
      rem=(int)x%10;
      x=(int)x/10;
      if(rem>5){
                x++;
                }
      
      x=x*resolution*10;
      return x;
}     


//this function computes the derivative at a point      
float derivative(float a,float h){
      float der;
      der= (function(a+h)-function(a))/h;
      return der;
      }


/*this fuction scans the given range for critical points, the points thus found 
are stored in a two dimensional array called opt[2][size]. The 1st row of the
array opt stores first size no. of local maxima encountered and the 2nd row
stores the first size no. of local minima encountered. If more maxima or minima
points are to be analysed then the value of size is to be increased. The
function returns the pointer to the element opt[0][0] using which two separate
arrays called max[size] and min[size] are generated in the main program.
The zeroth element of both these arrays contains the number of maxima/minima 
points in the specified range and the first elements contain the x coordinate of
the point where there exists a global maxima/minima in the given range   */ 
float *optima(float a, float b){
      float h;//h is the change in x over which derivative is calculated
      h=(b-a)*resolution;
      float d1,d2;
      //variable d1 and d2 store the derivatives at a point c and c+h respectively
      float opt[size][size];//array to store the values
      opt[0][0]=0;
      opt[1][0]=0;
      int i,j=1,k=1;//i keeps track of the iteration form a to b
      //ja nd k store the no. of maxima and minima respectively
      float pre,post;//pre and post store the values of derivatives at two 
      //successive points
      pre=derivative(a,h);
      for(i=1;(a+i*h)<b;i++){//iteration runs from a to b
              post=derivative(a+i*h,h);
              if(pre*post<0){//this condition means the derivative ha sa root in between
                              if(pre>0){//implies local maxima
                                        opt[0][j]=round(a+i*h);
                                        j++;
                                        }
                              else if(pre<0){//implies local minima
                                   opt[1][k]=round(a+i*h);
                                   k++;
                                   }
                              }
              pre=post;
              }
      opt[0][0]=j-1;
      opt[1][0]=k-1;
      //the global maxima and minima are calculated below and are stored in the
      //columns
      float gmax,gmin,swap;
      int jmax=1,kmin=1;
      if(j>1){
              gmax=function(opt[0][1]);
              for(i=2;i<j+1;i++){
                               if(function(opt[0][i])>gmax){
                                                         gmax=function(opt[0][i]);
                                                         jmax=i;
                                                         }
                               }
              swap=opt[0][1];
              opt[0][1]=opt[0][jmax];
              opt[0][jmax]=swap;
              }
      if(k>1){
              gmin=function(opt[1][1]);
              for(i=2;i<k+1;i++){
                               if(function(opt[1][i])<gmin){
                                                       gmin=function(opt[1][i]);
                                                       kmin=i;
                                                       }
                               }
              swap=opt[1][1];
              opt[1][1]=opt[1][kmin];
              opt[1][kmin]=swap;
              }
      return opt[0];//returning the pointer to the opt[0][0] element
}
      
      
//function to compute double derivative at a point whose x coordinate is c
//actually this function should also check for nonexistence of
//double derivative but since it is not exactly known how do display this 
//error it is not done here.This function requires to be modified later
float d_der(float c,float h){//h=(b-a)*resolution and should be given as input
            float val;
            val=(derivative((c+h),h)-derivative(c,h))/h;
            return val;
            }
            
            
// the section of the program given below is to be included in the main program 
int main(){
          float *p;
          float a,b;
          float max[size],min[size];//local max and min are stored in these arrays
          p=optima(a,b);//the value of a and b are to be asked from the user
          //here they are assumed  to be asked earlier
          //storing the local max and min in the respective array
          for(int i=0;i<size;i++){
                  max[i]=*p;
                  p++;
                  }
          for(int i=0;i<size;i++){
                  min[i]=*p;
                  p++;
                  }
          return 0;
}
